define([
    'underscore',
    'backbone',
    'App',
    'Layout',
    'modules/community-care-request/new-appointment-request-question/preferred-provider/preferred-provider-layout-view',
    'modules/community-care-request/new-appointment-request-question/preferred-provider/preferences/preferred-provider-section-view',
],
function (
    _,
    Backbone,
    app,
    Layout,
    PreferredProviderLayoutView,
    PreferredProviderSectionView
) {
    'use strict';

    describe('Primary-Care Layout', function () {
        var view;
        var $view;
        var layout = new Layout();
        var model;
        var continueButton;


        beforeEach(function () {
            model = new Backbone.Model(
                {
                    steps: [5],
                    primaryCity: '',
                    primaryState: '',
                    primaryZipCode: '',
                    primaryPreferredMiles: '',
                    preferredLanguageSpoken: '',
                    officeHours: '',
                }
            );
            spyOn(PreferredProviderLayoutView.prototype, 'routeToPrevious');
            spyOn(PreferredProviderLayoutView.prototype, 'toContinue');
            spyOn(PreferredProviderLayoutView.prototype, 'toExit');
            spyOn(PreferredProviderLayoutView.prototype, 'disableContinueButton').and.callThrough();
            spyOn(PreferredProviderLayoutView.prototype, 'enableContinueButton');
            spyOn(PreferredProviderLayoutView.prototype, 'ifAddressSetModel').and.callThrough();
            spyOn(PreferredProviderLayoutView.prototype, 'handleModelChange').and.callThrough();
            layout.render();
            view = new PreferredProviderLayoutView({
                model: model,
                validator: layout.validator,
            });
            layout.showChildView('content', view);
            $view = view.$el;
            continueButton = $view.find('#continue-btn');
        });
        afterEach(function () {
            layout.getRegion('content').empty();
        });

        describe('show primary care provider layout view', function () {
            it('has a button to the previous page', function() {
                var backButton = $view.find('#previous-btn');
                backButton.click();
                expect(view.routeToPrevious).toHaveBeenCalled();
            });
            it('has a button to exit the requests', function() {
                var exitButton = $view.find('#exit-btn');
                exitButton.click();
                expect(view.toExit).toHaveBeenCalled();
            });
        });

        describe('the provider model when address is present', function () {
            it('has an address model', function() {
                model = new Backbone.Model(
                    {
                        steps: [5],
                        address: '123 Testing St',
                        city: 'Hillhouse City',
                        state: 'MS',
                        zipCode: '22123',
                    }
                );
                view = new PreferredProviderLayoutView({model: model});
                expect(view.model.get('primaryCity')).toEqual('Hillhouse City');
                expect(view.model.get('primaryState')).toEqual('MS');
                expect(view.model.get('primaryZipCode')).toEqual('22123');
            });

            it('does not have an address model', function() {
                model = new Backbone.Model(
                    {
                        steps: [5],
                        primaryCity: '',
                        primaryState: '',
                        primaryZipCode: '',
                    }
                );
                view = new PreferredProviderLayoutView({model: model});
                expect(view.model.get('primaryCity')).toEqual('');
                expect(view.model.get('primaryState')).toEqual('');
                expect(view.model.get('primaryZipCode')).toEqual('');
            });
        });

        describe('continue button enables with correct validation ', function() {
            it(' has continue button primaryCity', function() {
                view.model.set('primaryCity', 'Boston');
                continueButton.click();
                expect(view.handleModelChange).toHaveBeenCalled();
                expect(view.toContinue).not.toHaveBeenCalled();
                expect(view.disableContinueButton).toHaveBeenCalled();
            });
            it('handle model changes with primaryState', function() {
                view.model.set('primaryCity', 'Boston');
                view.model.set('primaryState', 'MA');
                continueButton.click();
                expect(view.handleModelChange).toHaveBeenCalled();
                expect(view.toContinue).not.toHaveBeenCalled();
                expect(view.disableContinueButton).toHaveBeenCalled();
            });
            it('enables continue button when all fields are set', function() {
                view.model.set('primaryCity', 'Boston');
                view.model.set('primaryState', 'MA');
                view.model.set('primaryZipCode', '22190');
                view.model.set('primaryPreferredMiles', '50');
                view.model.set('preferredLanguageSpoken', 'English');
                view.model.set('officeHours', ['Weekdays']);
                expect(view.enableContinueButton).toHaveBeenCalled();
                expect(view.handleModelChange).toHaveBeenCalled();
            });
        });
    });
});
